/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.impl.Player;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import org.joda.time.DateTime;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="aiPlayer")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class AIPlayer
extends Player
implements IAIPlayer {
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public AIPlayer(ICity homeTown, long cash, DateTime birthDate, GameFactory gameFactory) {
        super(homeTown, AIPlayer.getPersonalData(homeTown, birthDate), cash, ESocialRank.BARGAINER, gameFactory);
    }

    private static PersonalData getPersonalData(ICity homeTown, DateTime birthDate) {
        return new PersonalData(AIPlayer.getRandomFirstName(), AIPlayer.getRandomLastName(), true, homeTown, birthDate);
    }

    private static String getRandomFirstName() {
        return firstNameLoader.getRandomName();
    }

    private static String getRandomLastName() {
        return lastNameLoader.getRandomName();
    }
}

