/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.util.ClassChecker;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class Player
implements IPlayer {
    @ListType(value=IShip.class)
    private final ObservableList<IShip> fleet = FXCollections.observableArrayList();
    @ListType(value=INavigableVessel.class)
    private final ObservableList<INavigableVessel> selectableVessel = FXCollections.observableArrayList();
    private final long UUID;
    private ESocialRank rank;
    private ICareer careerLevel;
    private IPersonalData personalData;
    private ISpouseData spouse;
    private final ICompany company;
    private MapSegmentedImage segmentedMap;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public Player(ICity homeTown, IPersonalData personalData, long cash, ESocialRank rank, GameFactory gameFactory) {
        this.rank = rank;
        this.careerLevel = EEconomicCareer.INEXPERIENCED;
        this.personalData = personalData;
        this.company = gameFactory.createCompany(this, homeTown, cash);
        this.UUID = new Random().nextLong();
    }

    @PostConstruct
    private void init() {
    }

    @Override
    public String getName() {
        return this.personalData.getName();
    }

    @Override
    public String getLastName() {
        return this.personalData.getLastName();
    }

    @Override
    public ICity getHometown() {
        return this.company.getHomeTown();
    }

    @Override
    public List<IShip> getFleet() {
        return Collections.unmodifiableList(this.fleet);
    }

    @Override
    public List<INavigableVessel> getSelectableVessels() {
        return Collections.unmodifiableList(this.selectableVessel);
    }

    @Override
    public void addSelectableVessel(INavigableVessel vessel) {
        this.selectableVessel.add((Object)vessel);
    }

    @Override
    public void removeSelectableVessel(INavigableVessel vessel) {
        this.selectableVessel.remove((Object)vessel);
    }

    @Override
    public boolean isMale() {
        return this.personalData.isMale();
    }

    @Override
    public void addShip(IShip ship) {
        this.fleet.add((Object)ship);
    }

    @Override
    public void removeShip(IShip ship) {
        this.fleet.remove((Object)ship);
    }

    @Override
    public long getCash() {
        return this.company.getCash();
    }

    @Override
    public void updateCash(int diff) {
        this.company.updateCash(diff);
    }

    @Override
    public List<IBuilding> findBuildings(ICity city) {
        ArrayList<IBuilding> result = new ArrayList<IBuilding>();
        for (IBuilding building : city.getBuildings()) {
            if (building.getOwner() != this) continue;
            result.add(building);
        }
        return result;
    }

    @Override
    public ITradingOffice findTradingOffice(ICity city) {
        for (IBuilding building : city.getBuildings()) {
            if (building.getOwner() != this || !(building instanceof ITradingOffice)) continue;
            return (ITradingOffice)building;
        }
        return null;
    }

    @Override
    public <T extends IBuilding> List<T> findBuildings(ICity city, Class<T> buildingClass) {
        ArrayList<IBuilding> result = new ArrayList<IBuilding>();
        for (IBuilding building : city.getBuildings()) {
            ClassChecker checker = new ClassChecker(building.getClass());
            if (!checker.extendsClass(buildingClass) && !checker.implementsInterface(buildingClass) || !building.getOwner().equals(this)) continue;
            result.add(building);
        }
        return result;
    }

    public void marry(ISpouseData spouse) {
        this.spouse = spouse;
    }

    public void widow() {
        this.spouse = null;
    }

    @Override
    public IPersonalData getPersonalData() {
        return this.personalData;
    }

    @Override
    public ISpouseData getSpouseData() {
        return this.spouse;
    }

    @Override
    public void updateRank(ESocialRank rank) {
        this.rank = rank;
    }

    @Override
    public List<INavigableVessel> findShips(ICity city) {
        ArrayList ships = Lists.newArrayList();
        for (INavigableVessel ship : this.fleet) {
            if (!ship.getLocation().equals((Object)city.getCoordinates())) continue;
            ships.add(ship);
        }
        return ships;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        if (this.UUID != player.UUID) {
            return false;
        }
        return !(this.personalData != null ? !this.personalData.equals(player.personalData) : player.personalData != null);
    }

    public int hashCode() {
        int result = (int)(this.UUID ^ this.UUID >>> 32);
        result = 31 * result + (this.personalData != null ? this.personalData.hashCode() : 0);
        return result;
    }

    @Override
    public void receiveSum(long amount) {
        this.getCompany().updateCash(amount);
    }

    @Override
    public ESocialRank getRank() {
        return this.rank;
    }

    @Override
    public ICareer getCareerLevel() {
        return this.careerLevel;
    }

    @Override
    public ICompany getCompany() {
        return this.company;
    }

    @Override
    public MapSegmentedImage getSegmentedMap() {
        return this.segmentedMap;
    }

    @Override
    public void setSegmentedMap(MapSegmentedImage segmentedMap) {
        this.segmentedMap = segmentedMap;
    }
}

