/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CaptainState
implements ICaptain {
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    private DateTime birthDate;
    private String name;
    private int salary;
    private int tradingSkill;
    private int navigationSkill;
    private int fightingSkill;
    @OptionalType(value=IShip.class)
    private Optional<IShip> ship;
    private static final Range<Integer> skillRange = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5));
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    @PostConstruct
    private void init() {
        this.name = firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName();
        this.birthDate = this.date.getCurrentDate().minusYears(this.rnd.nextInt(15) + 25).minusMonths(this.rnd.nextInt(12)).minusDays(this.rnd.nextInt(30));
        this.setFightSkillLevel(this.rnd.nextInt(6));
        this.setTradingSkillLevel(this.rnd.nextInt(6));
        this.setNavigationSkillLevel(this.rnd.nextInt(6));
        this.setSalary(this.rnd.nextInt(6) + 10 + this.tradingSkill * 2 + this.navigationSkill * 2 + this.fightingSkill * 2);
        this.ship = Optional.empty();
    }

    @Override
    public int getAge() {
        return Years.yearsBetween((ReadableInstant)this.birthDate, (ReadableInstant)this.date.getCurrentDate()).getYears();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSalary() {
        return this.salary;
    }

    @Override
    public int getTradingSkillLevel() {
        return this.tradingSkill;
    }

    @Override
    public int getNavigationSkillLevel() {
        return this.navigationSkill;
    }

    @Override
    public int getFightSkillLevel() {
        return this.fightingSkill;
    }

    public void setTradingSkillLevel(int level) {
        Preconditions.checkArgument((boolean)skillRange.contains((Comparable)Integer.valueOf(level)), (Object)"Level must be within [0,5]");
        this.tradingSkill = level;
    }

    public void setNavigationSkillLevel(int level) {
        Preconditions.checkArgument((boolean)skillRange.contains((Comparable)Integer.valueOf(level)), (Object)"Level must be within [0,5]");
        this.navigationSkill = level;
    }

    public void setFightSkillLevel(int level) {
        Preconditions.checkArgument((boolean)skillRange.contains((Comparable)Integer.valueOf(level)), (Object)"Level must be within [0,5]");
        this.fightingSkill = level;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    @Override
    public void assignToShip(IShip ship) {
        ship.setCaptain(this);
    }

    @Override
    public Optional<IShip> getAssignedShip() {
        return this.ship;
    }
}

