/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.sea.TravellingVessel;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.geometry.Point2D;
import javafx.scene.shape.Path;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
public class TravellingVessels
implements Iterable<INavigableVessel> {
    @MapType(key=INavigableVessel.class, value=TravellingVessel.class)
    private final Map<INavigableVessel, TravellingVessel> vessels = new ConcurrentHashMap<INavigableVessel, TravellingVessel>();

    public void addVessel(INavigableVessel vessel, Path path, List<Point2D> points, boolean visibleOnMap) {
        TravellingVessel tv = new TravellingVessel(vessel);
        tv.setCalculatablePath(points);
        tv.setDrwawablePath(path);
        tv.setDisplayVessel(visibleOnMap);
        this.vessels.put(vessel, tv);
    }

    public void remove(INavigableVessel vessel) {
        this.vessels.remove(vessel);
    }

    @Override
    public Iterator<INavigableVessel> iterator() {
        return this.vessels.keySet().iterator();
    }

    public TravellingVessel getTravellingVessel(INavigableVessel vessel) {
        return this.vessels.get(vessel);
    }
}

