/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import java.util.List;
import java.util.Optional;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ShipService {
    public int calculateShipsWeaponsStrength(INavigableVessel ship) {
        int strength = 0;
        strength += ship.getWeaponAmount(EWeapon.BALLISTA_BIG) * 2;
        strength += ship.getWeaponAmount(EWeapon.TREBUCHET_BIG) * 2;
        strength += ship.getWeaponAmount(EWeapon.CANNON) * 2;
        strength += ship.getWeaponAmount(EWeapon.BOMBARD) * 2;
        strength += ship.getWeaponAmount(EWeapon.BALLISTA_SMALL);
        return strength += ship.getWeaponAmount(EWeapon.TREBUCHET_SMALL);
    }

    public Optional<INavigableVessel> findShipByUuid(List<INavigableVessel> fleet, String uuid) {
        for (INavigableVessel vessel : fleet) {
            if (!uuid.equals(vessel.getUuid())) continue;
            return Optional.of(vessel);
        }
        return Optional.empty();
    }
}

