/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.persistence.converter;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.persistence.converter.BooleanPropertyConverter;
import ch.sahits.game.openpatrician.persistence.converter.ContributionConverter;
import ch.sahits.game.openpatrician.persistence.converter.DateTimeConverter;
import ch.sahits.game.openpatrician.persistence.converter.DoublePropertyConverter;
import ch.sahits.game.openpatrician.persistence.converter.IConverterProvider;
import ch.sahits.game.openpatrician.persistence.converter.IntegerPropertyConverter;
import ch.sahits.game.openpatrician.persistence.converter.LongPropertyConverter;
import ch.sahits.game.openpatrician.persistence.converter.NonReplacableMapConverter;
import ch.sahits.game.openpatrician.persistence.converter.ObjectPropertyConverter;
import ch.sahits.game.openpatrician.persistence.converter.ObservableListConverter;
import ch.sahits.game.openpatrician.persistence.converter.ObservableMapConverter;
import ch.sahits.game.openpatrician.persistence.converter.PathConverter;
import ch.sahits.game.openpatrician.persistence.converter.Point2DConverter;
import ch.sahits.game.openpatrician.persistence.converter.WareConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ConverterProvider
implements IConverterProvider {
    public List<Converter> getXStreamConverters(Mapper mapper) {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        converters.add((Converter)new DateTimeConverter());
        converters.add((Converter)new LongPropertyConverter());
        converters.add((Converter)new IntegerPropertyConverter());
        converters.add((Converter)new DoublePropertyConverter());
        converters.add((Converter)new ObservableListConverter(mapper));
        converters.add((Converter)new ObjectPropertyConverter(mapper));
        converters.add((Converter)new BooleanPropertyConverter());
        converters.add(new WareConverter());
        converters.add(new ContributionConverter());
        converters.add((Converter)new NonReplacableMapConverter(mapper));
        converters.add((Converter)new ObservableMapConverter(mapper));
        converters.add((Converter)new Point2DConverter());
        converters.add((Converter)new PathConverter());
        return converters;
    }
}

