/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.util;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.data.map.Map;
import ch.sahits.game.openpatrician.data.map.MapSegments;
import ch.sahits.game.openpatrician.data.map.PirateHideout;
import ch.sahits.game.openpatrician.data.map.PirateNest;
import ch.sahits.game.openpatrician.data.map.SunkenTreasure;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.PirateMapSegmentImage;
import ch.sahits.game.openpatrician.model.TreasureMapSegmentImage;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import ch.sahits.game.openpatrician.model.util.IMapSegmentImageCreator;
import ch.sahits.game.openpatrician.server.MapLocationDetectionModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.geometry.Point2D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MapSegmentImageFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private Random rnd;
    @Autowired
    private CityFactory cityFactory;
    @Autowired
    private IMapSegmentImageCreator imageCreator;
    @Autowired
    private MapLocationDetectionModel dataModel;
    @ListType(value=MapSegmentedImage.class)
    private List<MapSegmentedImage> pirateHideOuts;
    @ListType(value=MapSegmentedImage.class)
    private List<MapSegmentedImage> sunkShips;

    public void initializeImages() {
        Map map = this.cityFactory.getMap();
        this.pirateHideOuts = new ArrayList<MapSegmentedImage>();
        this.sunkShips = new ArrayList<MapSegmentedImage>();
        MapSegments mapSegments = map.getMapSegments();
        this.imageCreator.loadMap(map.getImageName());
        for (PirateNest pirateNest : mapSegments.getPirateNest()) {
            try {
                this.imageCreator.createMapSegment(pirateNest, map.getImageName());
            }
            catch (IOException e) {
                this.logger.error("Failed to create pirate map segment.", (Throwable)e);
            }
        }
        for (SunkenTreasure sunkenTreasure : mapSegments.getSunkenTreasure()) {
            try {
                this.imageCreator.createMapSegment(sunkenTreasure, map.getImageName());
            }
            catch (IOException e) {
                this.logger.error("Failed to create pirate map segment.", (Throwable)e);
            }
            this.sunkShips.add(new TreasureMapSegmentImage(sunkenTreasure.getImgName(), new Point2D((double)sunkenTreasure.getX(), (double)sunkenTreasure.getX()), sunkenTreasure.getTreasure()));
        }
        for (PirateHideout hideout : mapSegments.getPirateHideout()) {
            try {
                this.imageCreator.createMapSegment(hideout, map.getImageName());
            }
            catch (IOException e) {
                this.logger.error("Failed to create pirate map segment.", (Throwable)e);
            }
            this.pirateHideOuts.add(new PirateMapSegmentImage(hideout.getImgName(), new Point2D((double)hideout.getX(), (double)hideout.getX()), 1, hideout.getName()));
        }
    }

    public MapSegmentedImage getRandomPirateNest() {
        MapSegmentedImage mapImage = this.getRandomImage(this.pirateHideOuts);
        return this.checkMapUnused(mapImage, this.pirateHideOuts);
    }

    private MapSegmentedImage checkMapUnused(MapSegmentedImage mapImage, List<MapSegmentedImage> segmentList) {
        while (this.dataModel.containsSegment(mapImage)) {
            mapImage = this.getRandomImage(segmentList);
        }
        return mapImage;
    }

    public MapSegmentedImage getRandomTreasureNest() {
        MapSegmentedImage mapImage = this.getRandomImage(this.sunkShips);
        return this.checkMapUnused(mapImage, this.sunkShips);
    }

    private MapSegmentedImage getRandomImage(List<MapSegmentedImage> imgList) {
        MapSegmentedImage img = imgList.get(this.rnd.nextInt(imgList.size()));
        int availableSegment = this.rnd.nextInt(9);
        img.addSegment(availableSegment);
        return img;
    }
}

