package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

/**
 * Singleton beans holding all players.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 28, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class PlayerList implements Iterable<IPlayer> {
    @ListType(IPlayer.class)
    private List<IPlayer> players = new ArrayList<>();

    public int size() {
        return players.size();
    }

    public boolean isEmpty() {
        return players.isEmpty();
    }

    public boolean contains(Object o) {
        return players.contains(o);
    }

    public Iterator<IPlayer> iterator() {
        return players.iterator();
    }

    public boolean add(IPlayer player) {
        return players.add(player);
    }

    @Override
    public boolean equals(Object o) {
        return players.equals(o);
    }

    @Override
    public int hashCode() {
        return players.hashCode();
    }

    public IPlayer get(int index) {
        return players.get(index);
    }

    public Stream<IPlayer> stream() {
        return players.stream();
    }
}
