package ch.sahits.game.openpatrician.model.building;

import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.IntegerProperty;
import ch.sahits.game.openpatrician.model.building.ELevel;

/**
 * Additional over all ware houses connected to a trading office 
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
public interface IStorage {
	/**
	 * Retrieve the amount of storage in barrels that is rented by someone else
	 * @return
	 */
	public IntegerProperty rentOutStorageProperty();
	/**
	 * Update the rented out space
	 * @param nbBarrels
	 */
	public void updateRendedSpace(int nbBarrels);
	/**
	 * Retrieve the daily cost for rent storage
	 * @return
	 */
	public IntegerBinding costsPerDayBinding();
	/**
	 * Retrieve the number of guards
	 * @return
	 */
	public IntegerProperty numberGuardsProperty();
	/**
	 * Retrieve the costs for the guards
	 * @return
	 */
	public IntegerBinding guardCostsPerDayBinding();
	/**
	 * Retrieve the security level
	 * @return
	 */
	public ObjectBinding<ELevel> securityLevelBinding();
	/**
	 * Increase or decrease the number of guards
	 * @param update
	 */
	public void updateGuardsNumber(int update);

}
