package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.ICitizen;
import org.joda.time.DateTime;

/**
 * Request for a loan.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
public interface ILoanRequest {
    /**
     * Retrieve the date when the request was issued. This date is always in the past.
      * @return
     */
    DateTime issued();

    /**
     * Who wants the loan.
     * @return
     */
    ICitizen getCitizen();

    /**
     * Retrieve the duration of the loan.
     * @return
     */
    int getDurationInWeeks();

    /**
     * Amount to be loaned.
     * @return
     */
    int getSum();
}
