package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.ICitizen;

import java.util.ArrayList;
import java.util.List;

/**
 * Holds a list of alderman candidates.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 27, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AldermanCandidateList {
    @ListType(ICitizen.class)
    private ArrayList<ICitizen> aldermanCandidates = new ArrayList<>();

    public int size() {
        return aldermanCandidates.size();
    }

    public ICitizen get(int index) {
        return aldermanCandidates.get(index);
    }

    public boolean add(ICitizen iCitizen) {
        return aldermanCandidates.add(iCitizen);
    }

    public List<ICitizen> getAll() {
        return aldermanCandidates;
    }
}
