package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Builder;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;


/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@RequiredArgsConstructor
@Builder
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class Debt implements IDebt {
    @Getter
    private final ICitizen debitor;
    @Getter
    private final ICreditor creditor;
    @Getter
    @NonNull
    private final DateTime dueDate;
    @Getter
    private final double interest;
    @Getter
    private final int amount;
    @NonNull
    private final DateTime loanTakeOut;

    @Override
    public long getLoanedDuration(DateTime now) {
        Interval interval = new Interval(loanTakeOut, now);
        Duration duration = interval.toDuration();
        return duration.getStandardDays() + 1;
    }

    @Override
    public long getTotalDuration() {
        Interval interval = new Interval(loanTakeOut, dueDate);
        Duration duration = interval.toDuration();
        return duration.getStandardDays() + 1;
    }
}
