package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.ship.IShip;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
/**
 * Implementation of the due date for ships.
 * The Ship due date can be compared for ordering based on the due date.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Mar 9, 2013
 *
 */
@Prototype
@EqualsAndHashCode
@RequiredArgsConstructor
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class ShipDueDate implements IShipDueDate, Comparable<IShipDueDate> {
    @Getter
	private final IShip ship;
    @Getter
	private final DateTime dueDate;


	@Override
	public int compareTo(IShipDueDate other) {
		return dueDate.compareTo(other.getDueDate());
	}
}
