package ch.sahits.game.openpatrician.model.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 03, 2015
 */
public abstract class AbstractMapRegistry<K,V> {
    private final Map<K, V> map = new HashMap<>();

    public V get(Object key) {
        return map.get(key);
    }

    public V put(K key, V value) {
        return map.put(key, value);
    }

    public Set<K> keySet() {
        return map.keySet();
    }

    public Collection<V> values() {
        return map.values();
    }

    public Set<Entry<K, V>> entrySet() {
        return map.entrySet();
    }
}
