package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IPerson;
import lombok.Getter;

/**
 * Event indicating that a person in the city left the tavern.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Mar 2, 2013
 *
 */
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class PersonLeavesTavernEvent {
    @Getter
	private final ICity city;
	@Getter
	private final IPerson person;


	public PersonLeavesTavernEvent(ICity city, IPerson person) {
		super();
		this.city = city;
		this.person = person;
	}


}
