package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.util.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public final class Company implements ICompany {
	@XStreamOmitField
	private final Logger logger = LogManager.getLogger(Company.class);

	private IPlayer owner = null;
    @Getter
	private ICity homeTown;
    @Getter
	@Setter
	private long companyValue;
	private LongProperty cash;

	@Autowired
	@XStreamOmitField
	private IJavaFXApplicationThreadExecution threadExecutor;


	public Company(ICity homeTown, long cash, long random) { // Random argument is to avoid returning duplicate beans when creating a new instance
		super();
		this.homeTown = homeTown;
		this.cash = new SimpleLongProperty(this, "cash", cash);
	}

	public void setOwner(IPlayer player) {
		Preconditions.checkNotNull(player);
		Preconditions.checkArgument(owner == null, "The owner may only be set once");
		this.owner = player;
	}


	@Override
	public long getCash() {
		return cash.get();
	}
	/**
	 * Add or subtract some cash
	 * @param diff amount of money that is transferred
	 */
	@Override
	public void updateCash(long diff){
		threadExecutor.execute(() -> {
			cash.set(cash.get() + diff);
		});
	}

    @Override
    public LongProperty cashProperty() {
        return cash;
    }
}
