package ch.sahits.game.openpatrician.model.map;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import com.google.common.collect.Multimap;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;

import java.util.List;
import java.util.Set;


/**
 * Interface defining the map that defines the game plan
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 9, 2011
 *
 */
public interface IMap {
	/**
	 * Retrieve the number of cities that are on the map.
	 * @return
	 */
	int getNumberCities();
	/**
	 * Retrieve an unmodifiable list of all the cities in the map
	 * @return
	 */
	List<ICity> getCities();
    /**
     * Retrieve an unmodifiable list of all the cities in the map also including the once only visible to the player.
     * @return
     */
    List<ICity> getCities(IPlayer player);
    /**
     * Find a city by its name.
     * @param cityName
     * @return
     */
    ICity findCity(String cityName);

    /**
     * Retrieve the map dimensions
     * @return dimesion
     */
    Dimension2D getDimension();

    /**
     * Retrieve the path for the map image without the cities added.
     * @return
     */
    String getMapImagePath();

	/**
	 * Retrieve the path for the black and white variant of the map.
	 * @return
     */
	String getMapBWImagePath();

    List<ch.sahits.game.openpatrician.model.city.IFutureTowns> getFutureTowns();

    List<ILandBridge> getLandbridges();

    List<ch.sahits.game.openpatrician.model.sea.PirateNest> getPirateNests();

	/**
	 * Retrieve the scale of the map by providing a number to convert one kilometer into
	 * a number of pixels.
	 * @return
     */
	double getNumberOfPixelPerKilometer();

	/**
	 * Find the city at the given coordinates.
	 * @param location of the supposed city.
	 * @return instance of the city or null if at the coordinates there is no city.
     */
	ICity findCity(Point2D location);

	/**
	 * Retrieve a list of all coordinates of the cities.
	 * @return
     */
	List<Point2D> getCityCoordinates();

	/**
	 * Retrieve the cities that are currently being founded by players.
	 * @return
     */
	Multimap<IPlayer, ICity> getTownsInFounding();

	/**
	 * Add a new city.
	 * @param city
     */
	void add(ICity city);

	/**
	 * Retrieve the trade routes defined for this map.
	 * @return
     */
	Set<ITradeRoute> getTradeRoutes();
}
