package ch.sahits.game.openpatrician.model.map;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.SetType;
import javafx.geometry.Point2D;
import lombok.Getter;

import java.util.TreeSet;

/**
 * Model of a map segment which is split up and not all parts may be available.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 13, 2014
 */
@ClassCategory({EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MapSegmentedImage {
    @Getter
    private final String imageName;
    @Getter
    @SetType(Integer.class)
    private final TreeSet<Integer> segmentIndices;
    @Getter
    private final Point2D location;

    public MapSegmentedImage(String imageName, Point2D location) {
        this.imageName = imageName;
        this.location = location;
        segmentIndices = new TreeSet<>();
    }

    public void addSegment(int index) {
        segmentIndices.add(index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapSegmentedImage)) {
            return false;
        }

        MapSegmentedImage that = (MapSegmentedImage) o;

        if (getImageName() != null ? !getImageName().equals(that.getImageName()) : that.getImageName() != null) {
            return false;
        }
        return getLocation() != null ? getLocation().equals(that.getLocation()) : that.getLocation() == null;

    }

    @Override
    public int hashCode() {
        int result = getImageName() != null ? getImageName().hashCode() : 0;
        result = 31 * result + (getLocation() != null ? getLocation().hashCode() : 0);
        return result;
    }
}
