package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import org.joda.time.DateTime;

import java.util.Optional;

/**
 * Special case of a pirate. A non free pirate is hired by a
 * player. However after a time a non free pirate will become
 * a free pirate.
 */
public interface INonFreeSeaPirate extends ISeaPirate {
  /**
   * Indicates if the pirate is looting near the city.
   * @return optional of the ICity. If it is empty, it means the
   * pirate is not roaming near a city.
   */
  Optional<ICity> roamingNearCity();

  /**
   * Date when the pirate was hired by the player.
   * @return hiring date.
   */
  DateTime getHireDate();

  /**
   * Player who hired the pirate
   * @return reference to the player.
   */
  IPlayer getHiringPlayer();
}
