package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

/**
 * Defining the strategy for repaing a ship.
 */
public interface IAIShipRepairStrategy {
    /**
     * Decide if the <code>vessel</code> should be repaired, when it is in
     * <code>city</code>.
     * @param vessel that should be checked for repair need.
     * @param city current possition of the vessel.
     * @return true if the ship should be repaired.
     */
    boolean shouldRepair(INavigableVessel vessel, ICity city);

    /**
     * Initialize the reppair of the vessel.
     * @param vessel that should be repaired
     * @param city where the vessle currently anchors.
     */
    void repair(INavigableVessel vessel, ICity city);
}
