package ch.sahits.game.openpatrician.model.player;

import java.util.List;

/**
 * Interface for providing the various strategies for the AI.
 */
public interface IAIStrategyProvider {
    /**
     * Provide a list of AI strategy types for the trading.
     * @return
     */
    List<IAITradeStrategyType> getTradeStrategies();

    /**
     * Provide a list of repair strategy types.
     * @return
     */
    List<IAIShipRepairStrategyType> getRepairStrategies();

    /**
     * Provide a list of take loan strategies.
     * @return
     */
    List<IAITakeLoanStrategyType> getTakeLoanStrategies();
}
