package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.city.ICity;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.Set;

/**
 * Hold the state of all current blockades
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 14, 2016
 */
@LazySingleton
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class BlockadeState {
    @MapType(key=ICity.class, value = IBlockade.class)
    private Map<ICity, IBlockade> blockadedCity = new HashMap<>();

    /**
     * Add a blockade for the city.
     * @param city
     * @param blockade
     */
    public void addBlockade(ICity city, IBlockade blockade) {
        blockadedCity.put(city, blockade);
    }

    /**
     * Retrieve the blockade for the city. If the city is not
     * blockaded an Optional.empty is returned.
      * @param city for which the blockade objecd is to be retrieved.
     * @return
     */
    public Optional<IBlockade> getBlockade(ICity city) {
        if (blockadedCity.containsKey(city)) {
            return Optional.of(blockadedCity.get(city));
        } else {
            return Optional.empty();
        }
    }

    public Set<Entry<ICity, IBlockade>> entrySet() {
        return blockadedCity.entrySet();
    }

    /**
     * Finish the blockade.
     * @param city
     */
    public void finishBlockade(ICity city) {
        blockadedCity.remove(city);
    }
}
