package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.geometry.Point2D;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * Model for a pirates nest with its defending ships and other armerments.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 06, 2015
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class PirateNest {
    @Getter
    private final Point2D location;
    @Getter
    @ListType(IShip.class)
    private final List<IShip> defendingShips = new ArrayList<>();

    public PirateNest(Point2D location) {
        this.location = location;
    }
}
