package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point2D;
import javafx.scene.shape.Path;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 08, 2016
 */
@RequiredArgsConstructor
@Getter
@Setter
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class TravellingVessel {
    private final INavigableVessel vessel;
    /** Path that can be used to display on the map. This path is smoothed. */
    private Path drwawablePath;

    /**
     * List of points representing the path. This list is used to calculate
     * the position of the vessel.
     */
    @ListType(Point2D.class)
    private List<Point2D> calculatablePath;
    /**
     * Value between 0 and 1 indicating the position of the path.
     */
    private DoubleProperty positionOnPath = new SimpleDoubleProperty(0);
    /**
     * Property indicating if the position of the vessel should be drawn.
     */
    private BooleanProperty displayVessel = new SimpleBooleanProperty(false); // FIXME: 7/1/16 This information does not belong here as it is related to the UI  See #424

    public DoubleProperty positionOnPathProperty() {
        return positionOnPath;
    }

    public void setPositionOnPath(double positionOnPath) {
        this.positionOnPath.set(positionOnPath);
    }

    public BooleanProperty displayVesselProperty() {
        return displayVessel;
    }

    public void setDisplayVessel(boolean displayVessel) {
        this.displayVessel.set(displayVessel);
    }

    public double getPositionOnPath() {
        return positionOnPath.get();
    }

    public boolean getDisplayVessel() {
        return displayVessel.get();
    }
}
