package ch.sahits.game.openpatrician.model.sea.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import lombok.Getter;
import lombok.Setter;
import org.joda.time.DateTime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 14, 2016
 */
@Prototype
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class Blockade implements IBlockade {

    @Getter
    private final DateTime assemblyDate;
    @Getter
    private final DateTime endBlockade;
    @MapType(key = IPlayer.class, value = Integer.class)
    private Map<IPlayer, Integer> requestedShips = new HashMap<>();
    @MultimapType(key = IPlayer.class, value=IShip.class)
    private Multimap<IPlayer, IShip> ships = ArrayListMultimap.create();
    @Getter
    @ListType(IShip.class)
    private List<IShip> shipsToAuction = new ArrayList<>();
    @Setter
    private IConvoy convoy;

    public Blockade(DateTime assemblyDate, DateTime endBlockade) {
        this.assemblyDate = assemblyDate;
        this.endBlockade = endBlockade;
    }

    @Override
    public IConvoy getBlockadeConvoy() {
        return convoy;
    }

    @Override
    public List<IShip> getShips(IPlayer player) {
        return new ArrayList<>(ships.get(player));
    }

    public List<IShip> getShips() {
       return new ArrayList<>(ships.values());
    }
    
    public void requestShip(IPlayer player, int number) {
        requestedShips.put(player, number);
    }

    public int getNumberOfRequestedShips(IPlayer player) {
        return requestedShips.get(player);
    }
    public List<IPlayer> getPlayersWithRequestedShips() {
        return new ArrayList<>(requestedShips.keySet());
    }
    public void addShips(IPlayer player, List<IShip> shipList) {
        ships.putAll(player, shipList);
    }
    

    

    
    
}
