package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICrayer;

import java.util.Properties;


/**
 * This model represents a crayer.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 19, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Crayer extends Ship implements ICrayer {
	/**
	 * Constructor initializing the name and the upgrade level
	 * @param upgradeLevel
	 * @param name ships name
	 * @param shipConfiguration configuration properties
	 */
	public Crayer(EShipUpgrade upgradeLevel, String name, Properties shipConfiguration, long timestamp) {
		super(shipConfiguration);
		this.shipUpgradeLevel = upgradeLevel;
		this.name = name;
		ShipWeaponsLocationFactory factory = new ShipWeaponsLocationFactory();
		setShipWeaponsLocation(factory.getShipWeaponsLocation(EShipType.CRAYER, upgradeLevel));
	}
	/**
	 * Constructor for a Crayer without any upgrade
	 * @param name ships name
	 * @param shipConfiguration configuration properties
	 */
	public Crayer(String name, Properties shipConfiguration, long timestamp) {
		this(EShipUpgrade.NONE,name, shipConfiguration,timestamp);
	}



	@Override
	public void repair() {
		// TODO Auto-generated method stub

	}
	@Override
	public EShipType getShipType() {
		return EShipType.CRAYER;
	}

}
