package ch.sahits.game.openpatrician.persistence.converter;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 01, 2015
 */
@Service
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ConverterProvider implements IConverterProvider{
    public List<Converter> getXStreamConverters(Mapper mapper) {
        ArrayList<Converter> converters = new ArrayList<>();
        converters.add(new DateTimeConverter());
        converters.add(new LongPropertyConverter());
        converters.add(new IntegerPropertyConverter());
        converters.add(new DoublePropertyConverter());
        converters.add(new ObservableListConverter(mapper));
        converters.add(new ObjectPropertyConverter(mapper));
        converters.add(new BooleanPropertyConverter());
        converters.add(new WareConverter());
        converters.add(new ContributionConverter());
        converters.add(new NonReplacableMapConverter(mapper));
        converters.add(new ObservableMapConverter(mapper));
        converters.add(new Point2DConverter());
        converters.add(new PathConverter());
        converters.add(new WareMapConverter(mapper));
        return converters;
    }
}
