package ch.sahits.game.openpatrician.persistence.converter;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.product.EWare;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 01, 2015
 */
@ClassCategory(EClassCategory.STARTUP)
public class WareConverter implements Converter {
    @Override
    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        hierarchicalStreamWriter.addAttribute("ware", ((EWare)o).name());
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return EWare.valueOf(hierarchicalStreamReader.getAttribute("ware"));
    }

    @Override
    public boolean canConvert(Class aClass) {
        return EWare.class.equals(aClass);
    }
}
