package ch.sahits.game.openpatrician.server;

import javafx.geometry.Point2D;

/**
 * Base service for providing map locations.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 25, 2016
 */
public interface IMapLocationProviderFacade {
    /**
     * Retrieve a random ponint that is at sea.
     * @return point located on the sea.
     */
    Point2D getRandomPointAtSeaNear(Point2D location);


    /**
     * Retrieve a random ponint that is at sea.
     * @return point located on the sea.
     */
    Point2D getRandomPointAtSea();
}
