package ch.sahits.game.openpatrician.server;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 07, 2015
 */
@RequiredArgsConstructor
@Getter
@ClassCategory({EClassCategory.EVENT_OBJECT, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MapSegmentDataCheck {
    private final INavigableVessel ship;
    private final MapSegmentedImage mapSegment;
    private final DateTime deadline;
}
