/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IAmountable;
import ch.sahits.game.openpatrician.util.javafx.IJavaFXApplicationThreadExecution;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class BaseAmountable<T extends IAmountable> {
    protected final IntegerProperty amount = new SimpleIntegerProperty((Object)this, "amount", 0);
    @Autowired
    @XStreamOmitField
    protected IJavaFXApplicationThreadExecution fxTheadExecution;

    public int getAmount() {
        return this.amount.get();
    }

    public void add(int amount) {
        this.fxTheadExecution.execute(() -> {
            int localAmount = amount;
            if (localAmount < 0) {
                localAmount = Math.abs(localAmount);
            }
            this.amount.set(this.getAmount() + localAmount);
        });
    }

    public void remove(int amount) {
        this.fxTheadExecution.execute(() -> {
            int localAmount = amount;
            if (localAmount < 0) {
                localAmount = Math.abs(localAmount);
            }
            if (localAmount == Integer.MIN_VALUE) {
                localAmount = Integer.MAX_VALUE;
            }
            if (this.amount.get() < localAmount) {
                this.amount.set(0);
            } else {
                this.amount.set(this.getAmount() - localAmount);
            }
        });
    }

    public void reset() {
        this.fxTheadExecution.execute(() -> this.amount.set(0));
    }

    public String toString() {
        return String.valueOf(this.amount.get());
    }

    public IntegerProperty amountProperty() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseAmountable that = (BaseAmountable)o;
        return this.amount != null ? this.amount.get() == that.amount.get() : that.amount == null;
    }

    public int hashCode() {
        return this.amount != null ? this.amount.hashCode() : 0;
    }
}

