/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.EKontorType;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.Contributions;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.geometry.Point2D;
import org.joda.time.DateTime;

public interface ICity {
    public String getUniqueID();

    public EKontorType getKontorType();

    public String getName();

    public int getPopulation(EPopulationClass var1);

    public void setPopulation(int var1, EPopulationClass var2);

    public int move(IWare var1, int var2, ICitizen var3);

    public IWare[] getIneffectiveProduction();

    public IWare[] getEffectiveProduction();

    public List<IBuilding> getBuildings();

    public void tearDown(IBuilding var1);

    public void build(IBuilding var1);

    public IReputation getReputation(IPlayer var1);

    public void moveIn(IPlayer var1, IReputation var2, Contributions var3);

    public int getContribution(IPlayer var1, IWare var2);

    public Map<IWare, DateTime> getMissingWares();

    public Point2D getCoordinates();

    public List<IPlayer> getResidentPlayers();

    public CityState getCityState();

    public void setCityState(CityState var1);

    public AmountablePrice<IWare> getWare(IWare var1);

    public IntegerProperty getPopulationProperty(EPopulationClass var1);

    public IntegerBinding getPopulationBinding();

    public List<ICitizen> getCitizen();

    public <T extends IBuilding> List<T> findBuilding(Class<T> var1, Optional<IPlayer> var2);

    public String getNameTemplate();
}

