/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;

public interface IShipyard {
    public ICity getCity();

    public List<IShipDueDate> getShipBuildingList();

    public DateTime getBuildCompleteDate(EShipType var1);

    public void addShipBuildingOrder(IShipDueDate var1, Optional<TimedTask> var2);

    public void addShipRepairOrder(IShipDueDate var1, Optional<TimedTask> var2);

    public void addShipRefitOrder(IShipDueDate var1, Optional<TimedTask> var2);

    public void cancelShipBuildingOrder(DateTime var1);

    public List<IShipDueDate> getShipRepairList();

    public List<IShipDueDate> getShipUpgradeList();

    public void cancelRepair(IShip var1);

    public int calculateRepairCosts(int var1, int var2);

    public int calculateRepairMaterialCosts(IShip var1, int var2);

    public int calculateRefitCosts(EShipType var1, int var2);

    public int calculateRefitTime(EShipType var1);

    public EShipType[] getBuildableShipTypes();

    public int calculateConstructionCosts(EShipType var1);

    public int calculateBuildTime(EShipType var1);

    public int calculateRepairTime(EShipType var1);
}

