/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.util.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public final class Company
implements ICompany {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(Company.class);
    private IPlayer owner = null;
    private ICity homeTown;
    private long companyValue;
    private LongProperty cash;
    @Autowired
    @XStreamOmitField
    private IJavaFXApplicationThreadExecution threadExecutor;

    public Company(ICity homeTown, long cash, long random) {
        this.homeTown = homeTown;
        this.cash = new SimpleLongProperty((Object)this, "cash", cash);
    }

    public void setOwner(IPlayer player) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkArgument((this.owner == null ? 1 : 0) != 0, (Object)"The owner may only be set once");
        this.owner = player;
    }

    @Override
    public long getCash() {
        return this.cash.get();
    }

    @Override
    public void updateCash(long diff) {
        this.threadExecutor.execute(() -> this.cash.set(this.cash.get() + diff));
    }

    @Override
    public LongProperty cashProperty() {
        return this.cash;
    }

    @Override
    public ICity getHomeTown() {
        return this.homeTown;
    }

    @Override
    public long getCompanyValue() {
        return this.companyValue;
    }

    @Override
    public void setCompanyValue(long companyValue) {
        this.companyValue = companyValue;
    }
}

