/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.map.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.SetType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IFutureTowns;
import ch.sahits.game.openpatrician.model.map.ILandBridge;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.map.ITradeRoute;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.sea.PirateNest;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class GameMap
implements IMap {
    @ListType(value=ICity.class)
    private final LinkedList<ICity> cities = new LinkedList();
    @Autowired
    private CaptainsState captainsState;
    private Dimension2D dimension;
    private String mapImagePath;
    private String mapBWImagePath;
    private double numberOfPixelPerKilometer;
    @ListType(value=IFutureTowns.class)
    private final List<IFutureTowns> futureTowns = new ArrayList<IFutureTowns>();
    @ListType(value=ILandBridge.class)
    private final List<ILandBridge> landbridges = new ArrayList<ILandBridge>();
    @ListType(value=PirateNest.class)
    private final List<PirateNest> pirateNests = new ArrayList<PirateNest>();
    @MultimapType(key=IPlayer.class, value=ICity.class)
    private final Multimap<IPlayer, ICity> townsInFounding = ArrayListMultimap.create();
    @ListType(value=Point2D.class)
    private List<Point2D> cityCoordinates = new ArrayList<Point2D>();
    @SetType(value=ITradeRoute.class)
    private Set<ITradeRoute> tradeRoutes = new HashSet<ITradeRoute>();
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public void setup(Date date, Collection<ICity> cities, Dimension2D dim, String mapName, String bwImageName, double numberOfPixelPerKilometer) {
        this.dimension = dim;
        this.mapImagePath = mapName;
        this.mapBWImagePath = bwImageName;
        this.numberOfPixelPerKilometer = numberOfPixelPerKilometer;
        for (ICity city : cities) {
            this.add(city);
            this.cityCoordinates.add(city.getCoordinates());
        }
    }

    @Override
    public int getNumberCities() {
        return this.cities.size();
    }

    @Override
    public List<ICity> getCities() {
        return Collections.unmodifiableList(this.cities);
    }

    @Override
    public ICity findCity(String cityName) {
        for (ICity city : this.cities) {
            if (!city.getUniqueID().equals(cityName)) continue;
            return city;
        }
        return null;
    }

    @Override
    public void add(ICity city) {
        this.cities.add(city);
    }

    @Override
    public List<ICity> getCities(IPlayer player) {
        ArrayList<ICity> towns = new ArrayList<ICity>(this.cities);
        towns.addAll(this.townsInFounding.get((Object)player));
        return Collections.unmodifiableList(towns);
    }

    @Override
    public ICity findCity(Point2D location) {
        for (ICity city : this.getCities()) {
            if (!city.getCoordinates().equals((Object)location)) continue;
            return city;
        }
        return null;
    }

    public void addTradeRoute(ITradeRoute tradeRoute) {
        this.tradeRoutes.add(tradeRoute);
    }

    public void setCaptainsState(CaptainsState captainsState) {
        this.captainsState = captainsState;
    }

    @Override
    public Dimension2D getDimension() {
        return this.dimension;
    }

    @Override
    public String getMapImagePath() {
        return this.mapImagePath;
    }

    @Override
    public String getMapBWImagePath() {
        return this.mapBWImagePath;
    }

    @Override
    public double getNumberOfPixelPerKilometer() {
        return this.numberOfPixelPerKilometer;
    }

    @Override
    public List<IFutureTowns> getFutureTowns() {
        return this.futureTowns;
    }

    @Override
    public List<ILandBridge> getLandbridges() {
        return this.landbridges;
    }

    @Override
    public List<PirateNest> getPirateNests() {
        return this.pirateNests;
    }

    @Override
    public Multimap<IPlayer, ICity> getTownsInFounding() {
        return this.townsInFounding;
    }

    @Override
    public List<Point2D> getCityCoordinates() {
        return this.cityCoordinates;
    }

    @Override
    public Set<ITradeRoute> getTradeRoutes() {
        return this.tradeRoutes;
    }
}

