/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.SetType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.NewPirateEvent;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class SeaPiratesState {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    private IMap map;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Date date;
    @SetType(value=ISeaPirate.class)
    private Set<ISeaPirate> pirates = Sets.newHashSet();

    public void add(ISeaPirate pirate) {
        this.pirates.add(pirate);
        this.clientServerEventBus.post((Object)new NewPirateEvent(pirate));
    }

    public void remove(ISeaPirate pirate) {
        this.pirates.remove(pirate);
    }

    public void replace(INonFreeSeaPirate pirate, ISeaPirate replaceWith) {
        this.pirates.remove(pirate);
        this.pirates.add(replaceWith);
    }

    public List<ISeaPirate> getNonFreePirates(IPlayer player) {
        return Collections.unmodifiableList(this.pirates.stream().filter(p -> p instanceof INonFreeSeaPirate && ((INonFreeSeaPirate)p).getHiringPlayer().equals(player)).collect(Collectors.toList()));
    }

    public Set<ISeaPirate> getAllPirates() {
        return new HashSet<ISeaPirate>(this.pirates);
    }

    public Set<ISeaPirate> getFreePirates() {
        return this.pirates.stream().filter(p -> !(p instanceof INonFreeSeaPirate)).collect(Collectors.toSet());
    }

    public ISeaPirate findSuccessfulPirate() {
        int maxKill = 0;
        ISeaPirate successful = null;
        for (ISeaPirate pirate : this.getFreePirates()) {
            if (pirate.getNumberOfKills() < maxKill) continue;
            successful = pirate;
            maxKill = pirate.getNumberOfKills();
        }
        return successful;
    }
}

