/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.util.TransferUtil;
import ch.sahits.game.openpatrician.util.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.util.spring.DependentValue;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeaponsDealerState
implements IWeaponsDealer {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private DependentPropertyInitializer propertyInitializer;
    @DependentValue(value="tavern.weapons.dealer.sellvalue.factor")
    private double sellValue;
    @Autowired
    @XStreamOmitField
    private TransferUtil transferUtil;
    @MapType(key=IWeapon.class, value=IntegerProperty.class)
    private Map<IWeapon, IntegerProperty> weaponStore = new HashMap<IWeapon, IntegerProperty>();

    @PostConstruct
    public void init() {
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Failed to initialize DependentValue annotated fields");
        }
        this.addNewWare(EWeapon.SWORD, this.rnd.nextInt(5));
        this.addNewWare(EWeapon.BOW, this.rnd.nextInt(5));
        this.addNewWare(EWeapon.CROSSBOW, this.rnd.nextInt(5));
        this.addNewWare(EWeapon.MUSKET, this.rnd.nextInt(5));
    }

    private void addNewWare(IWeapon weapon, int amount) {
        this.weaponStore.put(weapon, (IntegerProperty)new SimpleIntegerProperty(amount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int move(IWeapon weapon, int amount) {
        IWeapon iWeapon = weapon;
        synchronized (iWeapon) {
            int amounted = this.getWeapon(weapon);
            if (amount < 0 && this.containsWare(weapon) && -amount > amounted) {
                amount = -amounted;
            }
            if (amount < 0 && !this.containsWare(weapon)) {
                amount = 0;
            }
            this.weaponStore.get(weapon).set(amounted + amount);
            return amount;
        }
    }

    protected final boolean containsWare(IWeapon weapons) {
        return this.weaponStore.containsKey(weapons) && this.weaponStore.get(weapons).get() > 0;
    }

    private int getWeapon(IWeapon weapon) {
        return this.weaponStore.get(weapon).get();
    }

    @Override
    public IntegerProperty amountAvailableProperty(EWeapon weapon) {
        return this.weaponStore.get(weapon);
    }
}

