/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.product.IPriceCalculation;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.SimplePriceCalculation;
import com.google.common.base.Preconditions;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class ComputablePriceV2 {
    private final IPriceCalculation calculation = new SimplePriceCalculation();

    public int calculateSellAmount(ITradable tradable, int availableAmount, int minPrice, int maxSellAmount) {
        int sellPriceAll = this.internalSellPriceCalculation(tradable, availableAmount, maxSellAmount);
        if (sellPriceAll > minPrice) {
            return maxSellAmount;
        }
        int halfAmount = (int)Math.round((double)maxSellAmount / 2.0);
        int sellPriceHalfAmount = this.internalSellPriceCalculation(tradable, availableAmount, halfAmount);
        if (sellPriceHalfAmount == minPrice) {
            return halfAmount;
        }
        int bottom = 1;
        int sellPriceBottom = this.internalSellPriceCalculation(tradable, availableAmount, bottom);
        if (sellPriceBottom < minPrice || availableAmount == bottom) {
            return 0;
        }
        return this.calculateSellAmountInHalf(tradable, availableAmount, minPrice, maxSellAmount, sellPriceHalfAmount, halfAmount, bottom);
    }

    private int calculateSellAmountInHalf(ITradable tradable, int availableAmount, int minPrice, int maxSellAmount, int sellPriceHalfAmount, int halfAmount, int bottom) {
        if (sellPriceHalfAmount > minPrice) {
            if (maxSellAmount == halfAmount + 1) {
                return halfAmount;
            }
            return this.calculateSellAmount(tradable, availableAmount, minPrice, halfAmount, maxSellAmount);
        }
        if (halfAmount == bottom + 1) {
            return bottom;
        }
        return this.calculateSellAmount(tradable, availableAmount, minPrice, 1, halfAmount);
    }

    private int calculateSellAmount(ITradable tradable, int availableAmount, int minPrice, int bottom, int top) {
        int halfAmount = (int)Math.round((double)(top - bottom + 1) / 2.0) + (bottom - 1);
        int sellPriceHalfAmount = this.internalSellPriceCalculation(tradable, availableAmount, halfAmount);
        if (sellPriceHalfAmount == minPrice) {
            return halfAmount;
        }
        if (bottom == halfAmount - 1) {
            return bottom;
        }
        int sellPriceAll = this.internalSellPriceCalculation(tradable, availableAmount, top);
        return this.calculateSellAmountInHalf(tradable, availableAmount, minPrice, top, sellPriceAll, halfAmount, bottom);
    }

    int internalSellPriceCalculation(ITradable tradable, int availableAmount, int amountToSell) {
        Preconditions.checkArgument((amountToSell > 0 ? 1 : 0) != 0, (Object)("The amount to sell must be larger than 0 (was " + availableAmount + ") for " + tradable.name()));
        Preconditions.checkArgument((availableAmount >= 0 ? 1 : 0) != 0, (Object)("The available amount must be positive for " + tradable.name()));
        int marketSaturation = tradable.getMarketSaturation();
        if (availableAmount >= marketSaturation) {
            return tradable.getMinValueSell();
        }
        int min = tradable.getMinValueSell();
        int max = tradable.getMaxValueSell();
        int firstItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount, marketSaturation, 0, null, null));
        if (amountToSell > 1) {
            int lastItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount + amountToSell, marketSaturation, 0, null, null));
            return (int)Math.rint((double)(firstItemPrice + lastItemPrice) / 2.0);
        }
        return firstItemPrice;
    }

    int internalBuyPriceCalculation(ITradable tradable, int availableAmount, int amountToBuy) {
        Preconditions.checkArgument((amountToBuy > 0 ? 1 : 0) != 0, (Object)("The amount to buy must be larger than 0 for " + tradable.name()));
        Preconditions.checkArgument((availableAmount >= 0 ? 1 : 0) != 0, (Object)("The available amount must be positive for " + tradable.name()));
        if (availableAmount == 0) {
            return 0;
        }
        if (availableAmount >= tradable.getMarketSaturation()) {
            return tradable.getMinValueBuy();
        }
        int min = tradable.getMinValueBuy();
        int max = tradable.getMaxValueBuy();
        int firstItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount, tradable.getMarketSaturation(), 0, null, null));
        if (amountToBuy > 1) {
            int lastItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount - amountToBuy, tradable.getMarketSaturation(), 0, null, null));
            return (int)Math.rint((double)(firstItemPrice + lastItemPrice) / 2.0);
        }
        return firstItemPrice;
    }

    public int buyPrice(ITradable tradable, IntegerProperty availableAmount, IntegerBinding amountToBuy) {
        return this.internalBuyPriceCalculation(tradable, availableAmount.get(), amountToBuy.get());
    }

    public int calculateBuyAmount(ITradable tradable, int availableAmount, int maxPrice, int maxAmount, long maxCash) {
        int max;
        if (availableAmount <= 0 || maxCash <= 0L) {
            return 0;
        }
        int min = tradable.getMinValueBuy();
        int firstItemPrice = (int)Math.rint(this.calculation.computePrice(min, max = tradable.getMaxValueBuy(), availableAmount, tradable.getMarketSaturation(), 0, null, null));
        if (firstItemPrice == maxPrice) {
            if ((long)firstItemPrice > maxCash) {
                return 0;
            }
            return 1;
        }
        if (firstItemPrice > maxPrice) {
            return 0;
        }
        int top = Math.min(maxAmount, availableAmount);
        if (top <= 1) {
            return 0;
        }
        return this.calculateBuyAmount(tradable, availableAmount, maxPrice, 1, top, firstItemPrice, maxCash);
    }

    private int calculateBuyAmount(ITradable tradable, int availableAmount, int maxPrice, int bottom, int top, int firstItemPrice, long maxCash) {
        Preconditions.checkArgument((bottom < top ? 1 : 0) != 0, (Object)"The top value must be larger than the bottom value");
        int min = tradable.getMinValueBuy();
        int max = tradable.getMaxValueBuy();
        int available = availableAmount - top + 1;
        int lastItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, available, tradable.getMarketSaturation(), 0, null, null));
        int priceAtTop = (int)Math.rint((double)(firstItemPrice + lastItemPrice) / 2.0);
        if (priceAtTop <= maxPrice && (long)(priceAtTop * top) < maxCash) {
            return top;
        }
        if (top == bottom + 1) {
            return bottom;
        }
        int middleAmount = (int)Math.round((double)(top - bottom + 1) / 2.0) + (bottom - 1);
        available = availableAmount - middleAmount + 1;
        int priceMiddleItem = (int)Math.rint(this.calculation.computePrice(min, max, available, tradable.getMarketSaturation(), 0, null, null));
        int priceAtMiddle = (int)Math.rint((double)(firstItemPrice + priceMiddleItem) / 2.0);
        if (priceAtMiddle == maxPrice && (long)priceAtMiddle < maxCash) {
            return middleAmount;
        }
        if (priceAtMiddle > maxPrice || (long)(priceAtMiddle * middleAmount) > maxCash) {
            if (middleAmount == bottom + 1) {
                return bottom;
            }
            return this.calculateBuyAmount(tradable, availableAmount, maxPrice, bottom, middleAmount, firstItemPrice, maxCash);
        }
        if (middleAmount == top - 1) {
            return middleAmount;
        }
        return this.calculateBuyAmount(tradable, availableAmount, maxPrice, middleAmount, top, firstItemPrice, maxCash);
    }

    public int sellPrice(ITradable tradable, IntegerProperty availableAmount, IntegerBinding amountToSell) {
        return this.internalSellPriceCalculation(tradable, availableAmount.get(), amountToSell.get());
    }
}

