/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.ECityState;
import ch.sahits.game.openpatrician.model.city.IPopulationStructure;
import ch.sahits.game.openpatrician.model.product.IPriceCalculation;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.When;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;

@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
final class SimplePriceCalculation
implements IPriceCalculation {
    SimplePriceCalculation() {
    }

    @Override
    public double computePrice(int min, int max, int available, int saturation, int productionRate, IPopulationStructure pop, ECityState state) {
        if (available == 0) {
            return max;
        }
        if (available >= saturation) {
            return min;
        }
        double val = Math.cos((double)available * Math.PI / (double)saturation);
        val += 1.0;
        val *= 0.5;
        val *= (double)(max - min);
        return val += (double)min;
    }

    public DoubleBinding computePrice(ReadOnlyIntegerProperty min, ReadOnlyIntegerProperty max, IntegerProperty available, ReadOnlyIntegerProperty saturation, int productionRate, IPopulationStructure pop, ECityState state) {
        return (DoubleBinding)new When((ObservableBooleanValue)available.isEqualTo(0)).then((ObservableNumberValue)max).otherwise((ObservableNumberValue)new When((ObservableBooleanValue)available.greaterThanOrEqualTo((ObservableNumberValue)saturation)).then((ObservableNumberValue)min).otherwise((ObservableNumberValue)this.cosinus(available, saturation.get()).add(1).multiply(0.5).multiply((ObservableNumberValue)max.subtract((ObservableNumberValue)min)).add((ObservableNumberValue)min)));
    }

    private DoubleBinding cosinus(final IntegerProperty available, final int saturation) {
        return new DoubleBinding(){
            {
                super.bind(new Observable[]{available});
            }

            protected double computeValue() {
                return Math.cos((double)available.getValue().intValue() * Math.PI / (double)saturation);
            }
        };
    }
}

