/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.product.IWare;
import java.util.HashMap;
import java.util.Map;

@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
@Prototype
public class ProductionStorage {
    @MapType(key=IWare.class, value=Double.class)
    private Map<IWare, Double> storage = new HashMap<IWare, Double>();

    public double getStored(IWare ware) {
        if (this.storage.containsKey(ware)) {
            return this.storage.get(ware);
        }
        return 0.0;
    }

    public double transfer(IWare ware, double amount) {
        double stored = this.getStored(ware);
        if (amount > 0.0) {
            this.storage.put(ware, stored += amount);
            return amount;
        }
        if (stored + amount > 0.0) {
            this.storage.put(ware, stored += amount);
            return amount;
        }
        this.storage.remove(ware);
        return -stored;
    }
}

