/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.AcceptedAldermanTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.joda.time.DateTime;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class AldermanOffice
implements IAldermanOffice {
    @ListType(value=IAldermanTask.class)
    private final ObservableList<IAldermanTask> tasks = FXCollections.observableArrayList();
    @OptionalType(value=ICityViolation.class)
    private Optional<ICityViolation> violation = Optional.empty();
    @ListType(value=IAcceptedAldermanTask.class)
    private List<IAcceptedAldermanTask> workedOnTasks = new ArrayList<IAcceptedAldermanTask>();

    @Override
    public void addTask(IAldermanTask task, DateTime limit, IPlayer player) {
        this.workedOnTasks.add(new AcceptedAldermanTask(task, limit, player));
    }

    @Override
    public void finished(IAldermanTask task) {
        Iterator<IAcceptedAldermanTask> iterator = this.workedOnTasks.iterator();
        while (iterator.hasNext()) {
            IAcceptedAldermanTask next = iterator.next();
            if (!task.equals(next.getTask())) continue;
            iterator.remove();
            break;
        }
    }

    public ObservableList<IAldermanTask> getTasks() {
        return this.tasks;
    }

    @Override
    public Optional<ICityViolation> getViolation() {
        return this.violation;
    }

    public void setViolation(Optional<ICityViolation> violation) {
        this.violation = violation;
    }

    @Override
    public List<IAcceptedAldermanTask> getWorkedOnTasks() {
        return this.workedOnTasks;
    }
}

