/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanRequest;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class LoanerState
implements ILoaner {
    @Value(value="${loaner.max.age.request}")
    private int maxRequestsPerWeek;
    private final ICity city;
    @ListType(value=IDebt.class)
    private List<IDebt> debts = new ArrayList<IDebt>();
    @ListType(value=ILoanRequest.class)
    private List<ILoanRequest> requests = new ArrayList<ILoanRequest>();
    @ListType(value=ILoanProposal.class)
    private List<ILoanProposal> loanProposals = new ArrayList<ILoanProposal>();
    @Autowired
    private Date date;

    public LoanerState(ICity city) {
        this.city = city;
    }

    @Override
    public void add(LoanProposal proposal) {
        this.loanProposals.add(proposal);
    }

    @Override
    public void add(LoanRequest request) {
        this.requests.add(request);
    }

    @Override
    public void clearOldRequests() {
        DateTime now = this.date.getCurrentDate();
        DateTime before4Weeks = now.minusWeeks(this.maxRequestsPerWeek);
        Iterator<ILoanRequest> iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            ILoanRequest request = iterator.next();
            if (!request.issued().isBefore((ReadableInstant)before4Weeks)) continue;
            iterator.remove();
        }
    }

    @Override
    public void addDebt(IDebt debt) {
        DateTime now = this.date.getCurrentDate();
        Preconditions.checkArgument((boolean)debt.getDueDate().isAfter((ReadableInstant)now));
        this.debts.add(debt);
    }

    @Override
    public ICity getCity() {
        return this.city;
    }

    @Override
    public List<IDebt> getDebts() {
        return this.debts;
    }

    @Override
    public List<ILoanRequest> getRequests() {
        return this.requests;
    }

    @Override
    public List<ILoanProposal> getLoanProposals() {
        return this.loanProposals;
    }
}

