/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Random;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class BaseTavernPerson
implements ITavernPerson {
    private DateTime arrivalDate;
    @Value(value="${tavern.person.presence.max}")
    private int maxDaysPresent;
    @Value(value="${tavern.person.absence.max}")
    private int maxDaysAbsent;
    private BooleanProperty isPresent = new SimpleBooleanProperty((Object)this, "isPresent", false);
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    private ICity city;
    @Autowired
    private Random rnd;

    @PostConstruct
    private void initArival() {
        this.arrivalDate = this.date.getStartDate().minusDays(this.rnd.nextInt(3));
    }

    @Override
    public boolean isPresent() {
        return this.isPresent.get();
    }

    @Override
    public BooleanProperty isPresentProperty() {
        return this.isPresent;
    }

    @Override
    public final void arrive() {
        this.arrivalDate = this.date.getCurrentDate();
        this.isPresent.set(true);
    }

    @Override
    public final void leave() {
        Preconditions.checkNotNull((Object)this.city);
        this.isPresent.set(false);
        this.clientServerEventBus.post((Object)new PersonLeavesTavernEvent(this.city, this));
    }

    @Override
    public int getNumberOfDaysSinceArrival() {
        DateTime now = this.date.getCurrentDate();
        Duration duration = new Duration((ReadableInstant)this.arrivalDate, (ReadableInstant)now);
        return duration.toStandardDays().getDays();
    }

    @Override
    public DateTime getArrivalDate() {
        return this.arrivalDate;
    }

    @Override
    public int getMaxDaysPresent() {
        return this.maxDaysPresent;
    }

    @Override
    public int getMaxDaysAbsent() {
        return this.maxDaysAbsent;
    }

    @Override
    public void setCity(ICity city) {
        this.city = city;
    }
}

