/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.OptionalGenericPairType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatable
public class InformantState
extends BaseTavernPerson
implements IInformant {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    private int price;
    private String name;
    @OptionalGenericPairType(key=ICity.class, value=IWare.class)
    private Optional<GenericPair<ICity, IWare>> wareNeeded = Optional.empty();
    @OptionalGenericPairType(key=ICity.class, value=IWare.class)
    private Optional<GenericPair<ICity, IWare>> wareSurplus = Optional.empty();
    @OptionalGenericPairType(key=String.class, value=ICity.class)
    private Optional<GenericPair<String, ICity>> pirateLocation = Optional.empty();
    private boolean showMapIfAvailable;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public InformantState() {
        this.name = firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName();
    }

    @Override
    public int getPrice(IPlayer player) {
        if (this.showMapIfAvailable && player.getSegmentedMap() != null) {
            return this.price + this.rnd.nextInt(1000) + 1000;
        }
        return this.price;
    }

    @Override
    public Optional<MapSegmentedImage> getMapSectionPart(IPlayer player) {
        if (player.getSegmentedMap() != null && this.showMapIfAvailable) {
            int index;
            MapSegmentedImage segmentedImage = player.getSegmentedMap();
            do {
                index = this.rnd.nextInt(9);
            } while (segmentedImage.getSegmentIndices().contains(index));
            segmentedImage.addSegment(index);
            return Optional.of(segmentedImage);
        }
        return Optional.empty();
    }

    @Override
    public void setPirateLocation(ISeaPirate pirate, ICity city) {
        this.pirateLocation = pirate != null && city != null ? Optional.of(new GenericPair((Object)(pirate.getName() + " " + pirate.getLastName()), (Object)city)) : Optional.empty();
    }

    @Override
    public void setNeededWare(ICity city, IWare ware) {
        this.wareNeeded = ware != null && city != null ? Optional.of(new GenericPair((Object)city, (Object)ware)) : Optional.empty();
    }

    @Override
    public void setWareSurplus(ICity city, IWare ware) {
        this.wareSurplus = ware != null && city != null ? Optional.of(new GenericPair((Object)city, (Object)ware)) : Optional.empty();
    }

    @Override
    public void setPrice(int price) {
        this.price = price;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Optional<GenericPair<ICity, IWare>> getWareNeeded() {
        return this.wareNeeded;
    }

    @Override
    public Optional<GenericPair<ICity, IWare>> getWareSurplus() {
        return this.wareSurplus;
    }

    @Override
    public Optional<GenericPair<String, ICity>> getPirateLocation() {
        return this.pirateLocation;
    }

    @Override
    public boolean isShowMapIfAvailable() {
        return this.showMapIfAvailable;
    }

    @Override
    public void setShowMapIfAvailable(boolean showMapIfAvailable) {
        this.showMapIfAvailable = showMapIfAvailable;
    }
}

