/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPirate;
import java.util.Optional;
import org.joda.time.DateTime;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class NonFreeSeaPirate
extends SeaPirate
implements INonFreeSeaPirate {
    @OptionalType(value=ICity.class)
    private final Optional<ICity> nearCity;
    private final IPlayer hiringPlayer;
    private final DateTime hireDate;

    public NonFreeSeaPirate(IPlayer hiringPlayer, DateTime hireDate, ICity nearCity) {
        this.nearCity = Optional.ofNullable(nearCity);
        this.hiringPlayer = hiringPlayer;
        this.hireDate = hireDate;
    }

    @Override
    public Optional<ICity> roamingNearCity() {
        return this.nearCity;
    }

    @Override
    public IPlayer getHiringPlayer() {
        return this.hiringPlayer;
    }

    @Override
    public DateTime getHireDate() {
        return this.hireDate;
    }
}

