/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class SailorsState
implements ISailorState {
    private final IntegerProperty nbSailors = new SimpleIntegerProperty((Object)this, "nbSailors", 0);
    private final BooleanProperty present = new SimpleBooleanProperty((Object)this, "present", false);

    public SailorsState() {
        this.present.bind((ObservableValue)this.nbSailors.greaterThan(0));
    }

    @Override
    public int getNumberOfSailors() {
        return this.nbSailors.get();
    }

    @Override
    public void setNumberOfSailors(int number) {
        this.nbSailors.set(Math.max(number, 0));
    }

    @Override
    public void hire() {
        if (this.getNumberOfSailors() > 0) {
            this.nbSailors.set(this.nbSailors.get() - 1);
        }
    }

    @Override
    public IntegerProperty numberOfSailorsProperty() {
        return this.nbSailors;
    }

    @Override
    public void fire() {
        this.nbSailors.set(this.nbSailors.get() + 1);
    }

    @Override
    public boolean isPresent() {
        return this.present.get();
    }
}

