/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.IAmountable;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.When;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AmountablePrice<T extends IAmountable>
extends BaseAmountable<T> {
    private final DoubleProperty sum = new SimpleDoubleProperty((Object)this, "sum", 0.0);

    public AmountablePrice() {
    }

    public AmountablePrice(int amount, double totalPrice) {
        this.amount.setValue((Number)amount);
        this.sum.setValue((Number)totalPrice);
    }

    public int getAVGPrice() {
        return (int)Math.rint(this.sum.doubleValue() / (double)this.amount.get());
    }

    public NumberBinding avgPriceProperty() {
        return new When((ObservableBooleanValue)this.sum.isEqualTo(0).or((ObservableBooleanValue)this.amount.isEqualTo(0))).then(0).otherwise((ObservableNumberValue)this.sum.divide((ObservableNumberValue)this.amount));
    }

    public void add(int amount, int avgPrice) {
        this.fxTheadExecution.execute(() -> {
            int localAmount = amount;
            if (localAmount < 0) {
                localAmount = Math.abs(localAmount);
            }
            int current = this.amount.get();
            this.amount.set(current + localAmount);
            long sum = this.sum.longValue();
            this.sum.set((double)(sum + (long)(localAmount * avgPrice)));
        });
    }

    @Override
    public void remove(int amount) {
        this.fxTheadExecution.execute(() -> {
            int localAmount = amount;
            if (localAmount < 0) {
                localAmount = Math.abs(localAmount);
            }
            if (localAmount == Integer.MIN_VALUE) {
                localAmount = Integer.MAX_VALUE;
            }
            if (this.amount.get() < localAmount) {
                this.amount.set(0);
                this.sum.set(0.0);
            } else {
                long sum = this.sum.longValue();
                this.sum.set((double)(sum - (long)(localAmount * this.getAVGPrice())));
                int current = this.amount.get();
                this.amount.set(current - localAmount);
            }
            if (this.amount.get() == 0) {
                this.sum.set(0.0);
            }
        });
    }

    @Override
    public void reset() {
        this.fxTheadExecution.execute(() -> {
            this.sum.set(0.0);
            super.reset();
        });
    }

    @Override
    public String toString() {
        return this.amount.get() + "@" + this.getAVGPrice();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AmountablePrice that = (AmountablePrice)o;
        return this.sum != null ? this.sum.get() == that.sum.get() : that.sum == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.sum != null ? this.sum.hashCode() : 0);
        return result;
    }

    public double getSum() {
        return this.sum.get();
    }
}

