/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.ECityState;
import ch.sahits.game.openpatrician.model.city.IPopulationStructure;
import ch.sahits.game.openpatrician.model.product.IPriceCalculation;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.When;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;

@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
final class LinearPriceCalculation
implements IPriceCalculation {
    LinearPriceCalculation() {
    }

    @Override
    public double computePrice(int min, int max, int available, int saturation, int productionRate, IPopulationStructure pop, ECityState state) {
        if (available == 0) {
            return max;
        }
        if (available >= saturation) {
            return min;
        }
        double slope = (double)(-(max - min)) / (1.0 * (double)saturation);
        return (double)available * slope + (double)max;
    }

    public IntegerBinding computePrice(ReadOnlyIntegerProperty min, ReadOnlyIntegerProperty max, IntegerProperty available, ReadOnlyIntegerProperty saturation, int productionRate, IPopulationStructure pop, ECityState state) {
        return (IntegerBinding)new When((ObservableBooleanValue)available.isEqualTo(0)).then((ObservableNumberValue)max).otherwise((ObservableNumberValue)new When((ObservableBooleanValue)available.greaterThanOrEqualTo((ObservableNumberValue)saturation)).then((ObservableNumberValue)min).otherwise((ObservableNumberValue)available.multiply((ObservableNumberValue)max.subtract((ObservableNumberValue)min).multiply(-1).divide((ObservableNumberValue)saturation)).add((ObservableNumberValue)max)));
    }
}

