/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.data.map.City;
import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.FoundNewSettlement;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Locale;
import java.util.Random;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

@Configuration
@ComponentScan(basePackages={"ch.sahits.game.openpatrician.model", "ch.sahits.game.openpatrician.util", "ch.sahits.game.openpatrician.persistence.converter"})
@ClassCategory(value={EClassCategory.STARTUP})
public class ModelConfiguration {
    @Autowired
    private Environment standardEnvironment;

    @Bean
    public Random rnd() {
        return new Random();
    }

    @Bean
    public Interner<Point2D> pointInterner() {
        return Interners.newStrongInterner();
    }

    @Bean
    public Jaxb2Marshaller jaxb2MapMarshaller() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.openpatrician.data.map");
        return bean;
    }

    @Bean
    public static PropertyPlaceholderConfigurer applicationProperties(@Value(value="#{systemProperties['user.home']}") String userHome) {
        PropertyPlaceholderConfigurer bean = new PropertyPlaceholderConfigurer();
        bean.setIgnoreUnresolvablePlaceholders(true);
        bean.setLocations(new Resource[]{new ClassPathResource("model-settings.properties"), new ClassPathResource("configuration.properties"), new FileSystemResource(userHome + "/.OpenPatrician/OpenPatricianConfiguration.properties")});
        return bean;
    }

    @Bean
    public PropertiesFactoryBean model() {
        PropertiesFactoryBean bean = new PropertiesFactoryBean();
        bean.setLocation((Resource)new ClassPathResource("populationConsume_default.properties"));
        return bean;
    }

    @Bean
    public Locale defaultLocale() {
        return Locale.ENGLISH;
    }

    @Bean
    public RandomNameLoader firstNameLoader() {
        return new RandomNameLoader("firstnames.properties");
    }

    @Bean
    public RandomNameLoader lastNameLoader() {
        return new RandomNameLoader("lastnames.properties");
    }

    @Bean
    public RandomNameLoader shipNameLoader() {
        return new RandomNameLoader("shipnames.properties");
    }

    @Bean
    public PropertiesFactoryBean modelProperties() {
        PropertiesFactoryBean propertyFact = new PropertiesFactoryBean();
        propertyFact.setLocation((Resource)new ClassPathResource("model.properties"));
        return propertyFact;
    }

    @Bean
    @Scope(value="prototype")
    public ICity cityBean(City cityData) {
        ch.sahits.game.openpatrician.model.city.impl.City city = new ch.sahits.game.openpatrician.model.city.impl.City(cityData);
        return city;
    }

    @Bean
    @Scope(value="prototype")
    public ICity cityBean(FoundNewSettlement cityData) {
        ch.sahits.game.openpatrician.model.city.impl.City city = new ch.sahits.game.openpatrician.model.city.impl.City(cityData);
        return city;
    }

    @Bean
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource bundle = new ReloadableResourceBundleMessageSource();
        bundle.setDefaultEncoding("UTF-8");
        bundle.setBasename("i18n/text");
        bundle.setFallbackToSystemLocale(false);
        return bundle;
    }

    @Bean
    @Scope(value="prototype")
    public BaseAmountable<IWeapon> weaponAmountable() {
        return new BaseAmountable<IWeapon>();
    }

    @Bean
    @Scope(value="prototype")
    public AmountablePrice<IWare> wareAmountable() {
        return new AmountablePrice<IWare>();
    }
}

