package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.geometry.Point2D;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Singleton beans holding all players.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 28, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AIPlayerList implements Iterable<IAIPlayer> {
    @ListType(IAIPlayer.class)
    private List<IAIPlayer> players = new ArrayList<>();

    public Iterator<IAIPlayer> iterator() {
        return players.iterator();
    }

    public boolean add(IAIPlayer player) {
        return players.add(player);
    }

    public List<IAIPlayer> getAll() {
        return players;
    }

    public List<IAIPlayer> findAIPlayersCurrentlyInCity(ICity city) {
        List<IAIPlayer> players = new ArrayList<>();
        Point2D coordinates = city.getCoordinates();
        for (IAIPlayer player : this.players) {
            if (player.findTradingOffice(city).isPresent()) {
                players.add(player);
            } else {
                List<IShip> fleet = player.getFleet();
                for (IShip ship : fleet) {
                    if (ship.getLocation().equals(coordinates)) {
                        players.add(player);
                        break;
                    }
                }
            }
        }
        return players;
    }
}
